<?php
 
include_once 'conexao.php';

class ModeloVagaClassificacao
{ 
       
	static public function mdlAddVagaClassificacao($dados){
		$stmt = Conexao::conectar()->prepare("INSERT INTO vagaclassificacao 
			(idVaga, idUsuario, estrelas, dataCadastro) VALUES 
		  (:idVaga, :idUsuario, :estrelas, :dataCadastro)");
		$data = date("d-m-Y H:i:s");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_INT);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_INT);
		$stmt->bindParam(":estrelas", $dados["estrelas"], PDO::PARAM_INT);
		$stmt->bindParam(":dataCadastro", $data, PDO::PARAM_STR);
	
		if($stmt->execute()){
			return "ok";
		} else {
			return "error";
		}
	}
	

	static public function mdlBuscarVagaClassificacao($idVaga, $idUsuario){
		$stmt = Conexao::conectar()->prepare("SELECT * FROM vagaclassificacao WHERE idVaga = :idVaga AND idUsuario = :idUsuario");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_INT);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_INT);
	
		$stmt->execute();
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}

	static public function mdlBuscarVagaClassificacaoPorIdVaga($idVaga){
		$stmt = Conexao::conectar()->prepare("SELECT * FROM vagaclassificacao WHERE idVaga = :idVaga ");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_INT);
		$stmt->execute();
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	 

	static public function mdlAtualizarEstrelasVagaClassificacao($idVaga, $idUsuario, $estrelas){
		$stmt = Conexao::conectar()->prepare("UPDATE vagaclassificacao SET estrelas = :estrelas WHERE idVaga = :idVaga AND idUsuario = :idUsuario");
		$stmt->bindParam(":estrelas", $estrelas, PDO::PARAM_INT);
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_INT);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_INT);
	
		if($stmt->execute()){
			return "ok";
		} else {
			return "error";
		}
	}
	

	
}



  ?>